CREATE OR REPLACE FORCE VIEW "W83B"."W83BMANTENIMIENTODELEGADOS" 
("N_ACTA_016", "ANO_ACTA_016", "C_TERRIT_016", "VERSION_016", "ID_CENTRO_016", "F_BAJA_016", "DNI_025", 
"NOMBRE_025", "APEL1_025", "APEL2_025", "F_BAJA_025", "C_SINDI_025", "NUM_ACTA_COMP", "CODTERRITORIO", 
"CODMUNICIPIO", "TERRITORIO", "MUNICIPIO", "RAZONSOCIAL", "TELEFONO", "CIFNIF", "DOMICILIO", "FAX") 
AS 
SELECT   	n_acta_016, ano_acta_016, c_territ_016, version_016,
					id_centro_016, f_baja_016, dni_025, nombre_025, apel1_025,apel2_025, f_baja_025,
					c_sindi_025, numactacom, codterritorio,
					codmunicipio,territorio,municipio, razonsocial, telefono, cifnif, domicilio, fax
FROM (SELECT tactas.n_acta_016 AS n_acta_016,
									 tactas.ano_acta_016 AS ano_acta_016,
									 tactas.c_territ_016 AS c_territ_016,
									 tactas.version_016 AS version_016,
									 tactas.id_centro_016 AS id_centro_016,
									 tactas.f_baja_016 AS f_baja_016,
									 tdelegado.dni_025 AS dni_025,
									 tdelegado.nombre_025 AS nombre_025,
									 tdelegado.apel1_025 AS apel1_025,
									 tdelegado.apel2_025 AS apel2_025,
									 tdelegado.f_baja_025 AS f_baja_025,
									 tdelegado.c_sindi_025 AS c_sindi_025,
									 tactas.c_territ_016
									 || '/'
									 || tactas.ano_acta_016
									 || '/'
									 || DECODE (LENGTH (TO_CHAR (tactas.n_acta_016)),
									 						 1, '00000' || TO_CHAR (tactas.n_acta_016),
                               2, '0000' || TO_CHAR (tactas.n_acta_016),
                               3, '000' || TO_CHAR (tactas.n_acta_016),
                               4, '00' || TO_CHAR (tactas.n_acta_016),
                               5, '0' || TO_CHAR (tactas.n_acta_016),
                               TO_CHAR (tactas.n_acta_016)
                              ) AS numactacom,
                    (select tprovincia.ds_o from t17i.t17_provincia tprovincia
                    where tprovincia.ID = centros.provc_001
                    ) AS territorio,
                    centros.provc_001 AS codterritorio,
                     (select ds_o from t17i.t17_municipio tmunicipio                     
                    where tmunicipio.ID = centros.MUNIC_001
                    and tmunicipio.PROVINCIA_ID = centros.provc_001
                    ) AS municipio,
                    centros.munic_001 AS codmunicipio,
                    centros.rsoc_001 AS razonsocial,
                    centros.tlf_001 AS telefono, centros.ccif_001 AS cifnif,
                    centros.domic_001 AS domicilio, centros.fax_001 AS fax
               FROM w83b16t00 tactas, w83b25t00 tdelegado, j7301s01 centros
              WHERE tactas.n_acta_016 = tdelegado.n_acta_025
                AND tactas.ano_acta_016 = tdelegado.ano_acta_025
                AND tactas.c_territ_016 = tdelegado.c_territ_025
                AND tactas.version_016 = tdelegado.version_025
                AND tactas.id_centro_016 = centros.ccen_001
                AND tactas.validada_016 = 1) consulta
      WHERE consulta.version_016 =
               (SELECT MAX (version_016)
                  FROM w83b16s00 act
                 WHERE consulta.n_acta_016 = act.n_acta_016
                   AND consulta.ano_acta_016 = act.ano_acta_016
                   AND consulta.c_territ_016 = c_territ_016
                   AND act.validada_016 = 1)
   ORDER BY consulta.c_territ_016,
            consulta.ano_acta_016,
            consulta.n_acta_016,
            consulta.version_016;